/*
 * Decompiled with CFR 0.152.
 */
package ms1167;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.Timer;
import ms1167.MotherShip;
import ms1167.Rocket;
import ms1167.Scene;
import ms1167.ScenePanel;

class Game
extends ScenePanel
implements ActionListener,
KeyListener {
    private JButton backButton;
    private JButton pauseButton;
    private JButton resetButton;
    private JProgressBar fieldPositionBar;
    private JProgressBar laserStatusBar;
    private JTextField speedDisplay;
    private JTextField scoreDisplay;
    private JTextField messageDisplay;
    private Rocket laserRocket;
    private MotherShip motherShip;
    private boolean isPaused;
    private boolean manualPause;
    private boolean hasExited;
    private boolean hasControl;
    private boolean rocketAlive = true;
    private boolean gameOver;
    private boolean gameWon;
    private boolean DAMPED;
    private Asteriod[] asteriods;
    private int NUM_ASTERIODS;
    private int FIELD_LENGTH;
    private int fieldPosition;
    private int starSpeedDiff;
    private int asteriodsActive;
    private int unactivatedAsteriods;
    private int TOP_TEXT_DEPTH = 25;
    private int score;
    public static final int ASTEROID_KILL_SCORE = 10;
    public static final int ROCKET_KILL_PENALTY = -250;
    public static final int LASER_SHOT_PENALTY = -6;
    public static final int FRAME_PENALTY = -1;
    public static final int UNDAMPED_BONUS = 200;
    public static final int ASTERIOD_PASSED_SCORE = 20;
    public static final int ROCKET_CONTROL_BONUS = 100;
    protected Polygon[][] asteriodShape;
    protected static Polygon explosion;
    protected Line2D.Double activeLaserBeam;
    protected static final int BOUNCE_BUFFER = 20;
    protected static final int ACTIVE_RADIUS = 40;
    private final String gameOverString = "GAME OVER";
    private final String gameWonString = "YOU WIN";
    private Font endGameFont = new Font("SansSerif", 3, 48);
    private FontMetrics endGameMetrics = ((Component)this).getFontMetrics(this.endGameFont);
    Timer rocketTimer;

    Game(Scene scene, int n, int n2, boolean bl) {
        super(scene);
        this.NUM_ASTERIODS = n;
        this.FIELD_LENGTH = n2;
        ScenePanel.STAR_SPEED = 5;
        this.DAMPED = bl;
        this.unactivatedAsteriods = n;
        this.score = this.FIELD_LENGTH / ScenePanel.STAR_SPEED;
        this.setExplosions();
        this.asteriodShape = Game.getAsteriodShape();
        this.rocketTimer = new Timer(50, this);
        this.rocketTimer.start();
        ScenePanel.starTimer.stop();
        this.backButton = new JButton("Quit");
        this.backButton.addActionListener(this);
        this.backButton.addKeyListener(this);
        this.resetButton = new JButton("Restart");
        this.resetButton.addActionListener(this);
        this.resetButton.addKeyListener(this);
        this.pauseButton = new JButton("Pause");
        this.pauseButton.addActionListener(this);
        this.pauseButton.addKeyListener(this);
        this.speedDisplay = this.makeTextField(5);
        this.speedDisplay.addKeyListener(this);
        this.scoreDisplay = this.makeTextField(5);
        this.scoreDisplay.addKeyListener(this);
        this.messageDisplay = this.makeTextField(15);
        this.messageDisplay.addKeyListener(this);
        this.fieldPositionBar = new JProgressBar(0, 2 * this.unactivatedAsteriods);
        this.laserStatusBar = new JProgressBar(0, 9);
        Box box = Box.createHorizontalBox();
        box.add(this.backButton);
        box.add(this.resetButton);
        box.add(new JLabel(" Status: "));
        box.add(this.messageDisplay);
        box.add(new JLabel(" Speed: "));
        box.add(this.speedDisplay);
        box.add(new JLabel(" Score: "));
        box.add(this.scoreDisplay);
        box.add(new JLabel(" Progress: "));
        box.add(this.fieldPositionBar);
        box.add(new JLabel(" "));
        box.add(this.pauseButton);
        this.buttonPanel.add(box);
        this.motherShip = new MotherShip((int)(this.panelSize.getWidth() - 220.0), (int)(this.panelSize.getHeight() / 2.0), 3, explosion);
        this.laserRocket = new Rocket(this.motherShip.controlArea.getX() + 150.0, this.motherShip.controlArea.getY() + 150.0, 1.5, ScenePanel.STAR_SPEED, bl, explosion);
        this.startAsteriods();
        this.pauseButton.grabFocus();
    }

    private void setExplosions() {
        explosion = new Polygon();
        explosion.addPoint(8, 0);
        explosion.addPoint(4, 2);
        explosion.addPoint(6, 6);
        explosion.addPoint(2, 4);
        explosion.addPoint(0, 8);
        explosion.addPoint(-2, 4);
        explosion.addPoint(-6, 6);
        explosion.addPoint(-4, 2);
        explosion.addPoint(-8, 0);
        explosion.addPoint(-4, -2);
        explosion.addPoint(-6, -6);
        explosion.addPoint(-2, -4);
        explosion.addPoint(0, -8);
        explosion.addPoint(2, -4);
        explosion.addPoint(6, -6);
        explosion.addPoint(4, -2);
    }

    void startAsteriods() {
        this.asteriods = new Asteriod[this.NUM_ASTERIODS];
        int n = 0;
        while (n < this.NUM_ASTERIODS) {
            this.asteriods[n] = new Asteriod();
            ++n;
        }
    }

    public void moveAsteriods() {
        int n = 0;
        while (n < this.NUM_ASTERIODS) {
            this.asteriods[n].moveAsteriod();
            ++n;
        }
    }

    public void killAsteriods(Line2D.Double double_) {
        int n = 0;
        while (n < this.NUM_ASTERIODS) {
            if (this.asteriods[n].isActive && ScenePanel.intersects(this.asteriods[n].mainRock, double_)) {
                this.asteriods[n].kill();
                this.score += 10 * (3 - this.asteriods[n].size) + 20;
            }
            ++n;
        }
    }

    private boolean asteriodsIntersect(Polygon polygon) {
        int n = 0;
        while (n < this.NUM_ASTERIODS) {
            if (this.asteriods[n].isActive && this.asteriods[n].isAlive && ScenePanel.intersects(this.asteriods[n].mainRock, polygon)) {
                this.asteriods[n].kill();
                return true;
            }
            ++n;
        }
        return false;
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        int n = 0;
        while (n < this.NUM_ASTERIODS) {
            this.asteriods[n].paintComponent(graphics);
            ++n;
        }
        this.motherShip.paintComponent(graphics);
        if (this.rocketAlive) {
            this.laserRocket.paintComponent(graphics);
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.gameOver) {
            this.paintBaseText(graphics2D, "GAME OVER");
        } else if (this.gameWon) {
            this.paintText(graphics2D, "YOU WIN");
            this.paintBaseText(graphics2D, "SCORE: " + this.score);
        }
    }

    private void paintBaseText(Graphics2D graphics2D, String string) {
        this.paintText(graphics2D, string, true);
    }

    private void paintText(Graphics2D graphics2D, String string) {
        this.paintText(graphics2D, string, false);
    }

    private void paintText(Graphics2D graphics2D, String string, boolean bl) {
        AffineTransform affineTransform = new AffineTransform();
        int n = bl ? (int)this.panelSize.getHeight() - this.TOP_TEXT_DEPTH : this.TOP_TEXT_DEPTH + this.endGameMetrics.getAscent();
        TextLayout textLayout = new TextLayout(string, this.endGameFont, new FontRenderContext(null, false, false));
        affineTransform.translate(this.panelSize.getWidth() / 2.0 - (double)(this.endGameMetrics.stringWidth(string) / 2), n);
        Stroke stroke = graphics2D.getStroke();
        graphics2D.setStroke(new BasicStroke(3.0f));
        graphics2D.setColor(Color.black);
        graphics2D.fill(textLayout.getOutline(affineTransform));
        graphics2D.setColor(Color.red);
        graphics2D.draw(textLayout.getOutline(affineTransform));
        graphics2D.setStroke(stroke);
    }

    public void Pause() {
        this.pauseButton.grabFocus();
        if (!this.gameOver && !this.gameWon) {
            this.messageDisplay.setText("Paused");
        }
        this.isPaused = true;
        this.manualPause = true;
    }

    public void unPause() {
        this.pauseButton.grabFocus();
        this.isPaused = this.gameOver || this.gameWon;
        this.manualPause = this.isPaused;
    }

    public void doPause() {
        if (this.isPaused) {
            this.unPause();
        } else {
            this.Pause();
        }
    }

    private void moveRocket() {
        this.score += -1;
        if (ScenePanel.STAR_SPEED < 60 && this.starSpeedDiff > 0 || ScenePanel.STAR_SPEED > 0 && this.starSpeedDiff < 0) {
            ScenePanel.STAR_SPEED += this.starSpeedDiff;
        }
        this.fieldPosition += ScenePanel.STAR_SPEED;
        this.fieldPositionBar.setValue(2 * this.unactivatedAsteriods + this.asteriodsActive);
        this.moveAsteriods();
        this.hasControl = this.motherShip.controlArea.contains(this.laserRocket.getXPosition(), this.laserRocket.getYPosition());
        if (this.rocketAlive) {
            this.laserRocket.moveRocket(ScenePanel.STAR_SPEED, this.hasControl);
            this.rocketAlive = this.laserRocket.isAlive();
            this.activeLaserBeam = this.laserRocket.getLaser();
            if (this.laserRocket.laserOn()) {
                this.score += -6;
            }
            if (this.laserRocket.laserOn() && this.laserRocket.hasSignal() && ScenePanel.intersects(this.motherShip.shipBody, this.activeLaserBeam) || ScenePanel.intersects(this.motherShip.shipBody, this.laserRocket.rocket)) {
                this.motherShip.kill();
            }
            if (this.asteriodsIntersect(this.laserRocket.rocket) || ScenePanel.intersects(this.motherShip.shipBody, this.laserRocket.rocket)) {
                this.laserRocket.kill();
                this.score += -250;
            }
            if (this.laserRocket.isAlive() && this.laserRocket.hasSignal() && this.laserRocket.laserOn()) {
                this.killAsteriods(this.activeLaserBeam);
            }
        }
        if (this.asteriodsIntersect(this.motherShip.shipBody) || this.asteriodsIntersect(this.motherShip.getShipExtension(ScenePanel.STAR_SPEED))) {
            this.motherShip.kill();
        }
        if (!this.rocketAlive) {
            this.messageDisplay.setText("Rocket Destroyed");
        } else if (this.laserRocket.getXPosition() > this.motherShip.controlArea.getX() + this.motherShip.controlArea.getWidth() && this.laserRocket.getXSpeed() >= -0.5 || this.laserRocket.getYPosition() < this.motherShip.controlArea.getY() || this.laserRocket.getYPosition() > this.motherShip.controlArea.getY() + this.motherShip.controlArea.getHeight()) {
            this.messageDisplay.setText("Rocket Lost");
        } else if (!this.hasControl) {
            this.messageDisplay.setText("Out Of Range");
        } else {
            this.messageDisplay.setText("Normal");
        }
        this.speedDisplay.setText("" + ScenePanel.STAR_SPEED);
        this.scoreDisplay.setText("" + this.score);
        if (!this.motherShip.isAlive()) {
            this.failGame();
        } else if (this.asteriodsActive <= 0 && this.unactivatedAsteriods <= 0) {
            this.winGame();
        }
    }

    private void failGame() {
        this.Pause();
        this.gameOver = true;
        this.messageDisplay.setText("GAME OVER");
        this.repaint();
    }

    private void winGame() {
        this.Pause();
        this.gameWon = true;
        this.messageDisplay.setText("YOU WIN");
        if (this.hasControl && this.laserRocket.isAlive()) {
            this.score += 100;
        }
        if (!this.DAMPED) {
            this.score += 200;
        }
        this.repaint();
    }

    private void checkExit() {
        this.isPaused = true;
        if (this.checkEndGame("quit")) {
            this.exitGame();
        }
        if (!this.manualPause) {
            this.isPaused = false;
        }
    }

    private void reset() {
        this.isPaused = true;
        if (this.checkEndGame("restart")) {
            this.rocketTimer.stop();
            this.calledFrom.showGame(this.NUM_ASTERIODS, this.DAMPED);
        }
        if (!this.manualPause) {
            this.isPaused = false;
        }
    }

    private boolean checkEndGame(String string) {
        return this.gameOver || this.gameWon || JOptionPane.showConfirmDialog(this, "Are you sure you want to " + string + " this game?", "Confirmation", 0) == 0;
    }

    private void exitGame() {
        this.rocketTimer.stop();
        ScenePanel.starTimer.start();
        this.calledFrom.showSplash();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.backButton) {
            this.checkExit();
        } else if (object == this.pauseButton) {
            this.doPause();
        } else if (object == this.resetButton) {
            this.reset();
        } else if (object == this.rocketTimer) {
            if (!this.isPaused && !this.hasExited) {
                this.moveRocket();
            }
            if (!this.isPaused) {
                this.moveStars();
                this.repaint();
            }
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (!this.gameOver) {
            switch (keyEvent.getKeyCode()) {
                case 38: {
                    this.laserRocket.accelerate(true);
                    break;
                }
                case 37: {
                    this.laserRocket.turnLeft(true);
                    break;
                }
                case 39: {
                    this.laserRocket.turnRight(true);
                    break;
                }
                case 65: {
                    this.laserRocket.fire(1);
                    break;
                }
                case 83: {
                    this.laserRocket.fire(2);
                    break;
                }
                case 68: {
                    this.laserRocket.fire(3);
                    break;
                }
                case 90: {
                    if (ScenePanel.STAR_SPEED >= 60) break;
                    this.starSpeedDiff = 1;
                    break;
                }
                case 88: {
                    if (ScenePanel.STAR_SPEED <= 0) break;
                    this.starSpeedDiff = -1;
                    break;
                }
                case 80: {
                    this.doPause();
                    break;
                }
            }
        }
        switch (keyEvent.getKeyCode()) {
            case 112: {
                this.reset();
                break;
            }
            case 27: {
                this.checkExit();
                break;
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (!this.gameOver) {
            switch (keyEvent.getKeyCode()) {
                case 38: {
                    this.laserRocket.accelerate(false);
                    break;
                }
                case 37: {
                    this.laserRocket.turnLeft(false);
                    break;
                }
                case 39: {
                    this.laserRocket.turnRight(false);
                    break;
                }
                case 65: {
                    this.laserRocket.ceaseFire(1);
                    break;
                }
                case 83: {
                    this.laserRocket.ceaseFire(2);
                    break;
                }
                case 68: {
                    this.laserRocket.ceaseFire(3);
                    break;
                }
                case 88: 
                case 90: {
                    this.starSpeedDiff = 0;
                    break;
                }
            }
        }
    }

    public void focusLost(FocusEvent focusEvent) {
        if (focusEvent.getSource() == this.pauseButton && focusEvent.getSource() != this.speedDisplay && focusEvent.getSource() != this.scoreDisplay && focusEvent.getSource() != this.messageDisplay && focusEvent.getSource() != this.backButton) {
            this.Pause();
        }
    }

    public static Polygon[][] getAsteriodShape() {
        Polygon[][] polygonArray = new Polygon[3][3];
        polygonArray[0][0] = new Polygon();
        polygonArray[0][0].addPoint(1, 3);
        polygonArray[0][0].addPoint(4, 0);
        polygonArray[0][0].addPoint(3, -3);
        polygonArray[0][0].addPoint(0, -3);
        polygonArray[0][0].addPoint(-3, -1);
        polygonArray[0][0].addPoint(-4, 2);
        polygonArray[0][0].addPoint(-3, 3);
        polygonArray[1][0] = new Polygon();
        polygonArray[1][0].addPoint(4, 2);
        polygonArray[1][0].addPoint(4, -1);
        polygonArray[1][0].addPoint(3, -2);
        polygonArray[1][0].addPoint(-2, -3);
        polygonArray[1][0].addPoint(-4, -1);
        polygonArray[1][0].addPoint(-5, 1);
        polygonArray[1][0].addPoint(-4, 2);
        polygonArray[1][0].addPoint(-3, 3);
        polygonArray[2][0] = new Polygon();
        polygonArray[2][0].addPoint(0, 5);
        polygonArray[2][0].addPoint(2, 4);
        polygonArray[2][0].addPoint(4, 2);
        polygonArray[2][0].addPoint(5, 0);
        polygonArray[2][0].addPoint(3, -2);
        polygonArray[2][0].addPoint(1, -2);
        polygonArray[2][0].addPoint(-2, -3);
        polygonArray[2][0].addPoint(-4, -1);
        polygonArray[2][0].addPoint(-5, 0);
        polygonArray[2][0].addPoint(-5, 2);
        polygonArray[2][0].addPoint(-4, 4);
        polygonArray[2][0].translate(0, -1);
        int n = 0;
        while (n < 3) {
            int n2 = 1;
            while (n2 < 3) {
                polygonArray[n][n2] = new Polygon(polygonArray[n][0].xpoints, polygonArray[n][0].ypoints, polygonArray[n][0].npoints);
                ScenePanel.expand(polygonArray[n][n2], n2 + 1);
                ++n2;
            }
            ++n;
        }
        return polygonArray;
    }

    class Asteriod
    extends JComponent {
        protected Polygon mainRock;
        double coOrdX;
        double coOrdY;
        double speedX;
        double speedY;
        double rotate;
        double angle;
        float asteriodSpeed;
        int shapeKey;
        int size;
        boolean isActive;
        private boolean isAlive = true;
        Color asteriodColor = new Color(0.8f, 0.4f, 0.0f);
        Color asteriodEdge = new Color(0.6f, 0.3f, 0.0f);

        Asteriod() {
            this.asteriodSpeed = (float)Math.random();
            this.asteriodSpeed += 0.2f;
            this.coOrdX = (double)(-Game.this.FIELD_LENGTH) * Math.random();
            this.coOrdY = (Game.this.panelSize.getHeight() + 80.0) * (Math.random() - 0.5) + Game.this.panelSize.getHeight() / 2.0;
            this.speedX = 3.0 * Math.random() - 1.0;
            this.speedY = 3.0 * Math.random() - 1.0;
            this.rotate = (Math.random() - 0.5) / 8.0;
            this.shapeKey = (int)(3.0 * Math.random());
            if (this.shapeKey > 2) {
                this.shapeKey = 2;
            }
            this.size = (int)(3.0 * Math.random());
            if (this.size > 2) {
                this.size = 2;
            }
        }

        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            Graphics2D graphics2D = (Graphics2D)graphics;
            if (!this.isAlive && this.isActive) {
                Polygon[] polygonArray = new Polygon[3];
                int n = 0;
                while (n < 3) {
                    polygonArray[n] = new Polygon(Game.explosion.xpoints, Game.explosion.ypoints, Game.explosion.npoints);
                    ScenePanel.expand(polygonArray[n], n + 1);
                    polygonArray[n].translate((int)this.coOrdX, (int)this.coOrdY);
                    ++n;
                }
                graphics2D.setColor(Color.red);
                graphics2D.fill(polygonArray[2]);
                graphics2D.setColor(Color.orange);
                graphics2D.fill(polygonArray[1]);
                graphics2D.setColor(Color.yellow);
                graphics2D.fill(polygonArray[0]);
            } else if (this.isActive) {
                graphics2D.setColor(this.asteriodColor);
                graphics2D.fill(this.mainRock);
                graphics2D.setColor(this.asteriodEdge);
                graphics2D.draw(this.mainRock);
            }
        }

        public void kill() {
            this.isAlive = false;
            Game.this.asteriodsActive--;
        }

        public boolean isAlive() {
            return this.isAlive;
        }

        public void moveAsteriod() {
            this.coOrdX += (double)ScenePanel.STAR_SPEED;
            if (!this.isAlive) {
                this.isActive = false;
            } else if (!this.isActive) {
                boolean bl = this.isActive = this.coOrdX > -40.0 && this.coOrdX < Game.this.panelSize.getWidth() + 40.0;
                if (this.isActive) {
                    Game.this.asteriodsActive++;
                    Game.this.unactivatedAsteriods--;
                }
            } else {
                boolean bl = this.isActive = this.coOrdX < Game.this.panelSize.getWidth() + 40.0;
                if (!this.isActive) {
                    Game.this.score += 20;
                    Game.this.asteriodsActive--;
                }
            }
            if (this.isActive) {
                this.coOrdX += this.speedX;
                this.coOrdY += this.speedY;
                this.angle += this.rotate;
                if (this.angle < 0.0) {
                    this.angle += 2.0;
                }
                if (this.angle > 2.0) {
                    this.angle -= 2.0;
                }
                if (this.coOrdY < -40.0) {
                    this.coOrdY = Game.this.panelSize.getHeight() + 40.0;
                } else if (this.coOrdY > Game.this.panelSize.getHeight() + 40.0) {
                    this.coOrdY = -40.0;
                }
                if (this.coOrdX < -20.0 && this.speedX <= (double)(-ScenePanel.STAR_SPEED)) {
                    this.speedX = -this.speedX;
                } else if (this.coOrdX > Game.this.panelSize.getWidth() + 20.0 && this.speedX >= (double)ScenePanel.STAR_SPEED) {
                    this.speedX = -this.speedX;
                }
                this.mainRock = new Polygon(Game.this.asteriodShape[this.shapeKey][this.size].xpoints, Game.this.asteriodShape[this.shapeKey][this.size].ypoints, Game.this.asteriodShape[this.shapeKey][this.size].npoints);
                ScenePanel.rotate(this.mainRock, this.angle);
                this.mainRock.translate((int)this.coOrdX, (int)this.coOrdY);
            }
        }
    }
}

