/*
 * Decompiled with CFR 0.152.
 */
package ms1167;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import javax.swing.JComponent;
import ms1167.ScenePanel;

class MotherShip
extends JComponent {
    protected Polygon shipBody;
    private Polygon explosion;
    private Polygon explodeSmall;
    private Polygon explodeMed;
    private Polygon explodeBig;
    protected Ellipse2D.Double controlArea;
    private Polygon[] window;
    private Line2D.Double[] ridgeLine;
    private Rectangle redLight;
    private Rectangle greenLight;
    private Rectangle engine;
    private Color engineColor = new Color(0.0f, 0.5f, 1.0f);
    private boolean isAlive = true;

    MotherShip(int n, int n2, int n3, Polygon polygon) {
        this.explosion = polygon;
        this.controlArea = new Ellipse2D.Double(n - 200, n2 - 200, 400.0, 400.0);
        this.shipBody = new Polygon();
        this.shipBody.addPoint(-9, 0);
        this.shipBody.addPoint(3, 3);
        this.shipBody.addPoint(2, 6);
        this.shipBody.addPoint(-2, 9);
        this.shipBody.addPoint(5, 6);
        this.shipBody.addPoint(6, 2);
        this.shipBody.addPoint(6, -2);
        this.shipBody.addPoint(5, -6);
        this.shipBody.addPoint(-2, -9);
        this.shipBody.addPoint(2, -6);
        this.shipBody.addPoint(3, -3);
        ScenePanel.expand(this.shipBody, n3);
        this.explodeSmall = new Polygon(this.explosion.xpoints, this.explosion.ypoints, this.explosion.npoints);
        this.explodeBig = new Polygon(this.explosion.xpoints, this.explosion.ypoints, this.explosion.npoints);
        this.explodeMed = new Polygon(this.explosion.xpoints, this.explosion.ypoints, this.explosion.npoints);
        ScenePanel.expand(this.explodeBig, n3 + 2);
        this.explodeBig.translate(n, n2);
        ScenePanel.expand(this.explodeMed, n3 + 1);
        this.explodeMed.translate(n, n2);
        ScenePanel.expand(this.explodeSmall, n3);
        this.explodeSmall.translate(n, n2);
        this.window = new Polygon[2];
        this.window[0] = new Polygon();
        this.window[0].addPoint(this.shipBody.xpoints[0] + 6, this.shipBody.ypoints[0] + 1);
        this.window[0].addPoint(this.shipBody.xpoints[1] - 1, this.shipBody.ypoints[1] - 1);
        this.window[0].addPoint(this.shipBody.xpoints[1] - 1, this.shipBody.ypoints[0] + 1);
        this.window[1] = new Polygon();
        int n4 = 0;
        while (n4 < 3) {
            this.window[1].addPoint(this.window[0].xpoints[n4], -this.window[0].ypoints[n4]);
            ++n4;
        }
        this.shipBody.translate(n, n2);
        this.window[0].translate(n, n2);
        this.window[1].translate(n, n2);
        this.redLight = new Rectangle(this.shipBody.xpoints[3], this.shipBody.ypoints[3], 1, 1);
        this.greenLight = new Rectangle(this.shipBody.xpoints[8], this.shipBody.ypoints[8] - 1, 1, 1);
        this.engine = new Rectangle(this.shipBody.xpoints[6] - 1, this.shipBody.ypoints[6], 3, this.shipBody.ypoints[5] - this.shipBody.ypoints[6]);
        this.ridgeLine = new Line2D.Double[3];
        this.ridgeLine[0] = new Line2D.Double(this.shipBody.xpoints[0], this.shipBody.ypoints[0], this.shipBody.xpoints[5], this.shipBody.ypoints[0]);
        this.ridgeLine[1] = new Line2D.Double(this.shipBody.xpoints[1], this.shipBody.ypoints[1], this.shipBody.xpoints[5], this.shipBody.ypoints[5]);
        this.ridgeLine[2] = new Line2D.Double(this.shipBody.xpoints[10], this.shipBody.ypoints[10], this.shipBody.xpoints[6], this.shipBody.ypoints[6]);
    }

    public Polygon getShipExtension(int n) {
        Polygon polygon = new Polygon();
        polygon.addPoint(this.shipBody.xpoints[1], this.shipBody.ypoints[1]);
        polygon.addPoint(this.shipBody.xpoints[2], this.shipBody.ypoints[2]);
        polygon.addPoint(this.shipBody.xpoints[3], this.shipBody.ypoints[3]);
        polygon.addPoint(this.shipBody.xpoints[3] + n, this.shipBody.ypoints[3]);
        polygon.addPoint(this.shipBody.xpoints[4] + n, this.shipBody.ypoints[4]);
        polygon.addPoint(this.shipBody.xpoints[5] + n, this.shipBody.ypoints[5]);
        polygon.addPoint(this.shipBody.xpoints[6] + n, this.shipBody.ypoints[6]);
        polygon.addPoint(this.shipBody.xpoints[7] + n, this.shipBody.ypoints[7]);
        polygon.addPoint(this.shipBody.xpoints[8] + n, this.shipBody.ypoints[8]);
        polygon.addPoint(this.shipBody.xpoints[8], this.shipBody.ypoints[8]);
        polygon.addPoint(this.shipBody.xpoints[9], this.shipBody.ypoints[9]);
        polygon.addPoint(this.shipBody.xpoints[10], this.shipBody.ypoints[10]);
        return polygon;
    }

    public void kill() {
        this.isAlive = false;
    }

    public boolean isAlive() {
        return this.isAlive;
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.isAlive) {
            graphics2D.setColor(Color.blue);
            graphics2D.draw(this.controlArea);
            graphics2D.setColor(Color.cyan);
            graphics2D.fill(this.engine);
            graphics2D.setColor(this.engineColor);
            graphics2D.draw(this.engine);
            graphics2D.setColor(Color.lightGray);
            graphics2D.fill(this.shipBody);
            graphics2D.setColor(Color.gray);
            graphics2D.draw(this.shipBody);
            int n = 0;
            while (n < this.ridgeLine.length) {
                graphics2D.draw(this.ridgeLine[n]);
                ++n;
            }
            graphics2D.setColor(Color.black);
            int n2 = 0;
            while (n2 < this.window.length) {
                graphics2D.fill(this.window[n2]);
                ++n2;
            }
            graphics2D.setColor(Color.lightGray);
            int n3 = 0;
            while (n3 < this.window.length) {
                graphics2D.draw(this.window[n3]);
                ++n3;
            }
            graphics2D.setColor(Color.red);
            graphics2D.draw(this.redLight);
            graphics2D.setColor(Color.green);
            graphics2D.draw(this.greenLight);
        } else {
            graphics2D.setColor(Color.red);
            graphics2D.fill(this.explodeBig);
            graphics2D.setColor(Color.orange);
            graphics2D.fill(this.explodeMed);
            graphics2D.setColor(Color.yellow);
            graphics2D.fill(this.explodeSmall);
        }
    }
}

