/*
 * Decompiled with CFR 0.152.
 */
package ms1167;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import javax.swing.JComponent;
import ms1167.ScenePanel;

class Rocket
extends JComponent {
    private double xSpeed;
    private double ySpeed;
    private int faceDirection;
    private int signalCounter;
    private int laserBuffer;
    private boolean accelerate;
    private boolean left;
    private boolean right;
    private boolean rocketFlame;
    private boolean hasSignal;
    private boolean signalLightOn;
    private boolean laserOn = true;
    private boolean isAlive = true;
    private boolean leftLaserOn;
    private boolean midLaserOn;
    private boolean rightLaserOn;
    private double coOrdX;
    private double coOrdY;
    private static final int DIR_STEPS = 16;
    private static final int MAX_SPEED = 10;
    private static final int LASER_LENGTH = 1000;
    public static final int LEFT_LASER = 1;
    public static final int MID_LASER = 2;
    public static final int RIGHT_LASER = 3;
    private static final double WIND_RES = 0.025;
    private final boolean isDamped;
    protected Polygon rocket;
    private Polygon rocketTemplate;
    private Polygon flameTemplate;
    private Polygon flame;
    private Polygon explosion;
    private Polygon explodeSmall;
    private Polygon explodeMed;
    private Polygon explodeBig;
    private Line2D.Double[] ridgeLine;
    private Line2D.Double leftLaser;
    private Line2D.Double rightLaser;
    private Rectangle redLight;
    private Rectangle greenLight;
    private Line2D.Double leftLaserBeam;
    private Line2D.Double midLaserBeam;
    private Line2D.Double rightLaserBeam;
    private Line2D.Double activeLaserBeam;
    private Ellipse2D.Double signalLight;
    private Color signalBlue = new Color(0.0f, 0.25f, 1.0f);

    public Rocket(double d, double d2, double d3, int n, boolean bl, Polygon polygon) {
        this.explosion = polygon;
        this.isDamped = bl;
        this.coOrdX = d;
        this.coOrdY = d2;
        this.ySpeed = 0.0;
        this.xSpeed = -n;
        this.faceDirection = (int)(d3 * 16.0 / 2.0);
        this.rocket = new Polygon();
        int n2 = 0;
        while (n2 < 4) {
            this.rocket.addPoint(0, 0);
            ++n2;
        }
        this.flame = new Polygon();
        int n3 = 0;
        while (n3 < 3) {
            this.flame.addPoint(0, 0);
            ++n3;
        }
        this.ridgeLine = new Line2D.Double[3];
        int n4 = 0;
        while (n4 < this.ridgeLine.length) {
            this.ridgeLine[n4] = new Line2D.Double();
            ++n4;
        }
        this.signalLight = new Ellipse2D.Double();
        this.redLight = new Rectangle(0, 0, 1, 1);
        this.greenLight = new Rectangle(0, 0, 1, 1);
        this.leftLaser = new Line2D.Double();
        this.rightLaser = new Line2D.Double();
        this.leftLaserBeam = new Line2D.Double();
        this.midLaserBeam = new Line2D.Double();
        this.rightLaserBeam = new Line2D.Double();
        this.setUpTemplates();
        this.updateRocket();
    }

    public void kill() {
        this.explodeSmall = new Polygon(this.explosion.xpoints, this.explosion.ypoints, this.explosion.npoints);
        this.explodeBig = new Polygon(this.explosion.xpoints, this.explosion.ypoints, this.explosion.npoints);
        this.explodeMed = new Polygon(this.explosion.xpoints, this.explosion.ypoints, this.explosion.npoints);
        ScenePanel.expand(this.explodeBig, 3);
        this.explodeBig.translate((int)this.coOrdX, (int)this.coOrdY);
        ScenePanel.expand(this.explodeMed, 2);
        this.explodeMed.translate((int)this.coOrdX, (int)this.coOrdY);
        ScenePanel.expand(this.explodeSmall, 1);
        this.explodeSmall.translate((int)this.coOrdX, (int)this.coOrdY);
        this.isAlive = false;
    }

    public boolean isAlive() {
        return this.isAlive;
    }

    public boolean hasSignal() {
        return this.hasSignal;
    }

    public double getXPosition() {
        return this.coOrdX;
    }

    public double getYPosition() {
        return this.coOrdY;
    }

    public double getXSpeed() {
        return this.xSpeed;
    }

    public double getYSpeed() {
        return this.ySpeed;
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.isAlive) {
            if (this.hasSignal && this.activeLaserBeam != null && this.laserOn) {
                graphics2D.setColor(Color.red);
                graphics2D.draw(this.activeLaserBeam);
            }
            graphics2D.setColor(Color.gray);
            graphics2D.draw(this.leftLaser);
            graphics2D.draw(this.rightLaser);
            if (this.rocketFlame) {
                graphics2D.setColor(Color.red);
                graphics2D.fill(this.flame);
                graphics2D.setColor(Color.yellow);
                graphics2D.draw(this.flame);
            }
            graphics2D.setColor(Color.lightGray);
            graphics2D.fill(this.rocket);
            graphics2D.setColor(Color.gray);
            graphics2D.draw(this.rocket);
            int n = 0;
            while (n < this.ridgeLine.length) {
                graphics2D.draw(this.ridgeLine[n]);
                ++n;
            }
            graphics2D.setColor(Color.red);
            graphics2D.fill(this.redLight);
            graphics2D.setColor(Color.green);
            graphics2D.fill(this.greenLight);
            if (this.hasSignal && this.signalLightOn) {
                graphics2D.setColor(this.signalBlue);
                graphics2D.fill(this.signalLight);
                graphics2D.draw(this.signalLight);
            }
        } else {
            graphics2D.setColor(Color.red);
            graphics2D.fill(this.explodeBig);
            graphics2D.setColor(Color.orange);
            graphics2D.fill(this.explodeMed);
            graphics2D.setColor(Color.yellow);
            graphics2D.fill(this.explodeSmall);
        }
    }

    private void setUpTemplates() {
        this.rocketTemplate = new Polygon();
        this.rocketTemplate.addPoint(0, 9);
        this.rocketTemplate.addPoint(6, -6);
        this.rocketTemplate.addPoint(0, -3);
        this.rocketTemplate.addPoint(-6, -6);
        this.flameTemplate = new Polygon();
        this.flameTemplate.addPoint(-3, -3);
        this.flameTemplate.addPoint(3, -3);
        this.flameTemplate.addPoint(0, -9);
    }

    private void updateRocket() {
        this.rocket = new Polygon(this.rocketTemplate.xpoints, this.rocketTemplate.ypoints, this.rocketTemplate.npoints);
        ScenePanel.rotate(this.rocket, (double)(2 * this.faceDirection) / 16.0);
        this.rocket.translate((int)this.coOrdX, (int)this.coOrdY);
        this.flame = new Polygon(this.flameTemplate.xpoints, this.flameTemplate.ypoints, this.flameTemplate.npoints);
        ScenePanel.rotate(this.flame, (double)(2 * this.faceDirection) / 16.0);
        this.flame.translate((int)this.coOrdX, (int)this.coOrdY);
        this.ridgeLine[0].setLine(this.rocket.xpoints[0], this.rocket.ypoints[0], this.coOrdX, this.coOrdY);
        this.ridgeLine[1].setLine(this.rocket.xpoints[1], this.rocket.ypoints[1], this.coOrdX, this.coOrdY);
        this.ridgeLine[2].setLine(this.rocket.xpoints[3], this.rocket.ypoints[3], this.coOrdX, this.coOrdY);
        this.redLight.setLocation(this.rocket.xpoints[1], this.rocket.ypoints[1]);
        this.greenLight.setLocation(this.rocket.xpoints[3], this.rocket.ypoints[3]);
        this.signalLight.setFrame(this.coOrdX - 1.0, this.coOrdY - 1.0, 2.0, 2.0);
        this.setLaser(this.leftLaser, this.leftLaserBeam, 0, 1, 0.75);
        this.setLaserBeam(this.midLaserBeam, 0, 0.0);
        this.setLaser(this.rightLaser, this.rightLaserBeam, 0, 3, -0.75);
    }

    private void setLaser(Line2D.Double double_, Line2D.Double double_2, int n, int n2, double d) {
        double d2 = (this.rocket.xpoints[n] + 2 * this.rocket.xpoints[n2]) / 3;
        double d3 = (this.rocket.ypoints[n] + 2 * this.rocket.ypoints[n2]) / 3;
        double_.setLine(d2, d3, d2 + 4.0 * Math.sin(Math.PI * 2 * ((double)this.faceDirection + d) / 16.0), d3 + 4.0 * Math.cos(Math.PI * 2 * ((double)this.faceDirection + d) / 16.0));
        this.setLaserBeam(double_2, double_.getX2(), double_.getY2(), d);
    }

    private void setLaserBeam(Line2D.Double double_, int n, double d) {
        double d2 = this.rocket.xpoints[n];
        double d3 = this.rocket.ypoints[n];
        double_.setLine(d2, d3, d2 + 1000.0 * Math.sin(Math.PI * 2 * ((double)this.faceDirection + d) / 16.0), d3 + 1000.0 * Math.cos(Math.PI * 2 * ((double)this.faceDirection + d) / 16.0));
    }

    private void setLaserBeam(Line2D.Double double_, double d, double d2, double d3) {
        double_.setLine(d, d2, d + 1000.0 * Math.sin(Math.PI * 2 * ((double)this.faceDirection + d3) / 16.0), d2 + 1000.0 * Math.cos(Math.PI * 2 * ((double)this.faceDirection + d3) / 16.0));
    }

    public boolean laserOn() {
        return this.laserOn;
    }

    public Line2D.Double getLaser() {
        Line2D.Double double_ = this.midLaserOn ? this.midLaserBeam : (this.rightLaserOn ? this.rightLaserBeam : (this.activeLaserBeam = this.leftLaserOn ? this.leftLaserBeam : null));
        this.laserOn = this.activeLaserBeam != null ? !this.laserOn : false;
        return this.activeLaserBeam;
    }

    public void fire(int n) {
        switch (n) {
            case 1: {
                this.leftLaserOn = true;
                break;
            }
            case 2: {
                this.midLaserOn = true;
                break;
            }
            case 3: {
                this.rightLaserOn = true;
            }
        }
    }

    public void ceaseFire(int n) {
        switch (n) {
            case 1: {
                this.leftLaserOn = false;
                break;
            }
            case 2: {
                this.midLaserOn = false;
                break;
            }
            case 3: {
                this.rightLaserOn = false;
            }
        }
    }

    public void accelerate(boolean bl) {
        this.accelerate = bl;
    }

    public void turnLeft(boolean bl) {
        this.left = bl;
    }

    public void turnRight(boolean bl) {
        this.right = bl;
    }

    private double getSpeed() {
        return Math.sqrt(this.ySpeed * this.ySpeed + this.xSpeed * this.xSpeed);
    }

    private double getVelocity() {
        return this.ySpeed * Math.cos(Math.PI * 2 * (double)this.faceDirection / 16.0) + this.xSpeed * Math.sin(Math.PI * 2 * (double)this.faceDirection / 16.0);
    }

    private double getVelocity(int n) {
        return this.ySpeed * Math.cos(Math.PI * 2 * (double)n / 16.0) + this.xSpeed * Math.sin(Math.PI * 2 * (double)n / 16.0);
    }

    private void addVelocity(double d) {
        this.xSpeed += d * Math.sin(Math.PI * 2 * (double)this.faceDirection / 16.0);
        this.ySpeed += d * Math.cos(Math.PI * 2 * (double)this.faceDirection / 16.0);
    }

    private void addVelocity(double d, int n) {
        this.xSpeed += d * Math.sin(Math.PI * 2 * (double)n / 16.0);
        this.ySpeed += d * Math.cos(Math.PI * 2 * (double)n / 16.0);
    }

    private double getSlideVelocity() {
        return this.ySpeed * Math.sin(Math.PI * 2 * (double)this.faceDirection / 16.0) - this.xSpeed * Math.cos(Math.PI * 2 * (double)this.faceDirection / 16.0);
    }

    private void addSlideVelocity(double d) {
        this.xSpeed -= d * Math.cos(Math.PI * 2 * (double)this.faceDirection / 16.0);
        this.ySpeed += d * Math.sin(Math.PI * 2 * (double)this.faceDirection / 16.0);
    }

    public void moveRocket(int n, boolean bl) {
        this.hasSignal = bl;
        if (this.isDamped) {
            this.addVelocity(-0.025 * this.getVelocity());
            this.addSlideVelocity(-0.025 * this.getSlideVelocity());
        }
        ++this.signalCounter;
        this.signalLightOn = this.signalCounter < 3;
        this.signalCounter %= 9;
        if (this.hasSignal && this.accelerate) {
            this.addVelocity(1.0);
        }
        boolean bl2 = this.rocketFlame = this.hasSignal && this.accelerate;
        if (this.hasSignal && this.left) {
            ++this.faceDirection;
        }
        if (this.hasSignal && this.right) {
            --this.faceDirection;
        }
        if (this.faceDirection < 0) {
            this.faceDirection += 16;
        }
        this.faceDirection %= 16;
        this.coOrdX += this.xSpeed + (double)n;
        this.coOrdY += this.ySpeed;
        this.updateRocket();
    }
}

