/*
 * Decompiled with CFR 0.152.
 */
package ms1167;

import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.UIManager;
import ms1167.Game;
import ms1167.Help;
import ms1167.ScenePanel;
import ms1167.Splash;

public class Scene
extends JFrame {
    private Splash splashPanel;
    private Game gamePanel;
    private Help helpPanel;
    private ScenePanel currentPanel;
    public static final String title = "Asteroid Rocket";
    public static final String version = " v 1.0";
    public static final String credit = "by Mark Shinn";
    public static final int FIELD_LENGTH = 3000;

    public static void main(String[] stringArray) {
        try {
            UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        Scene scene = new Scene();
        scene.drawFrontPage();
    }

    private void drawFrontPage() {
        this.setTitle(title);
        this.splashPanel = new Splash(this);
        this.helpPanel = new Help(this);
        this.getContentPane().add((Component)this.helpPanel, "Center");
        this.helpPanel.Shown();
        this.pack();
        this.getContentPane().remove(this.helpPanel);
        this.currentPanel = this.splashPanel;
        this.setResizable(false);
        this.splashPanel.startStars();
        this.getContentPane().add((Component)this.currentPanel, "Center");
        this.currentPanel.Shown();
        ((Component)this).setLocation(100, 100);
        this.addWindowListener(new WindowCloser());
        this.show();
    }

    private void changePanel(ScenePanel scenePanel) {
        this.getContentPane().remove(this.currentPanel);
        this.currentPanel = scenePanel;
        this.getContentPane().add(this.currentPanel);
        if (this.currentPanel.beenShown()) {
            this.repaint();
        } else {
            this.currentPanel.Shown();
            this.show();
        }
    }

    public void showHelp() {
        ScenePanel.starTimer.stop();
        this.changePanel(this.helpPanel);
    }

    public void showSplash() {
        this.changePanel(this.splashPanel);
        if (this.gamePanel != null) {
            ScenePanel.STAR_SPEED = 5;
        }
        ScenePanel.starTimer.start();
    }

    public void showGame(int n, boolean bl) {
        this.gamePanel = new Game(this, n, 3000, bl);
        this.changePanel(this.gamePanel);
        this.gamePanel.unPause();
    }

    class WindowCloser
    extends WindowAdapter {
        WindowCloser() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            System.exit(0);
        }

        public void windowDeactivated(WindowEvent windowEvent) {
            if (Scene.this.currentPanel == Scene.this.gamePanel) {
                Scene.this.gamePanel.Pause();
            }
        }
    }
}

