/*
 * Decompiled with CFR 0.152.
 */
package ms1167;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Line2D;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.Timer;
import ms1167.Scene;

class ScenePanel
extends JPanel
implements ActionListener {
    protected JPanel buttonPanel;
    protected JButton aboutButton;
    protected Scene calledFrom;
    private boolean shown;
    protected Dimension panelSize;
    static Timer starTimer;
    static Star[] stars;
    protected static final int NUM_STARS = 400;
    protected static final int BASE_STAR_SPEED = 5;
    protected static int STAR_SPEED;
    private JTabbedPane tabs;

    ScenePanel(Scene scene) {
        this.calledFrom = scene;
        this.panelSize = new Dimension(700, 440);
        this.setLayout(new BorderLayout());
        this.setBackground(Color.black);
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new BorderLayout());
        Dimension dimension = new Dimension(200, 200);
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new BorderLayout());
        String string = "by Mark Shinn\n\nAsteroid Rocket was programmed with Java 2 v 1.4.0\n\nThis version completed 31-04-2002\n\nSend bugs to: ms1167@bris.ac.uk\n\n";
        String string2 = "Give the mothership a limited shield.\n\nMake the asteriods bounce off each other, rather than just pass straight through.\n\nGive control over the angle the left and right lasers fire at.\n";
        this.tabs = new JTabbedPane();
        this.tabs.setPreferredSize(dimension);
        jPanel.add((Component)this.makeText("Asteroid Rocket v 1.0", Color.blue), "North");
        jPanel.add((Component)this.makeText(string, Color.black), "Center");
        jPanel.add((Component)this.makeText("\u00a9 Copyright: Mark Shinn, 2002", Color.red), "South");
        jPanel2.add((Component)this.makeText("Ideas for the future:\n", Color.blue), "North");
        jPanel2.add((Component)this.makeText(string2, Color.black), "Center");
        this.tabs.add("About", jPanel);
        this.tabs.add("Future", jPanel2);
        this.add((Component)this.buttonPanel, "South");
    }

    protected JTextArea makeText(String string, Color color) {
        JTextArea jTextArea = new JTextArea(string);
        jTextArea.setForeground(color);
        jTextArea.setEnabled(false);
        jTextArea.setDisabledTextColor(color);
        jTextArea.setFont(new Font("SansSerif", 0, 12));
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setEditable(false);
        jTextArea.setOpaque(false);
        return jTextArea;
    }

    protected JTextField makeTextField(int n) {
        JTextField jTextField = new JTextField(n);
        jTextField.setEditable(false);
        jTextField.setBorder(null);
        jTextField.setEnabled(false);
        jTextField.setDisabledTextColor(Color.black);
        return jTextField;
    }

    void startStars() {
        STAR_SPEED = 5;
        stars = new Star[400];
        int n = 0;
        while (n < 400) {
            ScenePanel.stars[n] = new Star();
            ++n;
        }
        starTimer = new Timer(50, this);
        starTimer.start();
    }

    public void moveStars() {
        int n = 0;
        while (n < 400) {
            stars[n].moveStar();
            ++n;
        }
    }

    public boolean beenShown() {
        return this.shown;
    }

    public void Shown() {
        this.shown = true;
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        int n = 0;
        while (n < 400) {
            stars[n].paintComponent(graphics);
            ++n;
        }
    }

    public static void expand(Polygon polygon, int n) {
        int n2 = 0;
        while (n2 < polygon.xpoints.length) {
            int n3 = n2++;
            polygon.xpoints[n3] = polygon.xpoints[n3] * n;
        }
        int n4 = 0;
        while (n4 < polygon.ypoints.length) {
            int n5 = n4++;
            polygon.ypoints[n5] = polygon.ypoints[n5] * n;
        }
    }

    public static void rotate(Polygon polygon, double d) {
        int n = 0;
        while (n < polygon.npoints) {
            int n2 = polygon.xpoints[n];
            int n3 = polygon.ypoints[n];
            polygon.xpoints[n] = (int)((double)n2 * Math.cos(Math.PI * d) + (double)n3 * Math.sin(Math.PI * d));
            polygon.ypoints[n] = (int)((double)n3 * Math.cos(Math.PI * d) - (double)n2 * Math.sin(Math.PI * d));
            ++n;
        }
    }

    public static boolean intersects(Polygon polygon, Line2D.Double double_) {
        if (double_ == null || polygon == null) {
            return false;
        }
        if (!double_.intersects(polygon.getBounds())) {
            return false;
        }
        if (polygon.contains(double_.x1, double_.y1) || polygon.contains(double_.x2, double_.y2)) {
            return true;
        }
        if (double_.intersectsLine(polygon.xpoints[0], polygon.ypoints[0], polygon.xpoints[polygon.npoints - 1], polygon.ypoints[polygon.npoints - 1])) {
            return true;
        }
        int n = 0;
        while (n < polygon.npoints - 1) {
            if (double_.intersectsLine(polygon.xpoints[n], polygon.ypoints[n], polygon.xpoints[n + 1], polygon.ypoints[n + 1])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static boolean intersects(Polygon polygon, Polygon polygon2) {
        if (polygon2 == null || polygon == null) {
            return false;
        }
        if (!polygon.getBounds().intersects(polygon2.getBounds())) {
            return false;
        }
        if (ScenePanel.intersects(polygon2, new Line2D.Double(polygon.xpoints[0], polygon.ypoints[0], polygon.xpoints[polygon.npoints - 1], polygon.ypoints[polygon.npoints - 1]))) {
            return true;
        }
        int n = 0;
        while (n < polygon.npoints - 1) {
            if (ScenePanel.intersects(polygon2, new Line2D.Double(polygon.xpoints[n], polygon.ypoints[n], polygon.xpoints[n + 1], polygon.ypoints[n + 1]))) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == starTimer) {
            this.moveStars();
            this.repaint();
        }
        if (object == this.aboutButton) {
            JOptionPane.showMessageDialog(this, this.tabs, "Asteroid Rocket v 1.0", -1, null);
        }
    }

    static {
        STAR_SPEED = 5;
    }

    class Star
    extends JComponent {
        Rectangle pointLight;
        double coOrdX;
        double coOrdY;
        float starSpeed = (float)Math.random();
        Color starBrightness = new Color(this.starSpeed, this.starSpeed, this.starSpeed);

        Star() {
            this.starSpeed += 0.2f;
            this.pointLight = new Rectangle(0, 0, 1, 1);
            this.coOrdX = ScenePanel.this.panelSize.getWidth() * Math.random();
            this.coOrdY = ScenePanel.this.panelSize.getHeight() * Math.random();
            this.pointLight.setLocation(new Point((int)this.coOrdX, (int)this.coOrdY));
        }

        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setColor(this.starBrightness);
            graphics2D.draw(this.pointLight);
        }

        private void resetStar() {
            this.starSpeed = (float)(0.8 * Math.random());
            this.starBrightness = new Color(this.starSpeed, this.starSpeed, this.starSpeed);
            this.starSpeed += 0.2f;
            if (STAR_SPEED >= 0) {
                this.coOrdX = 0.0;
                this.pointLight.setLocation(new Point(0, (int)(ScenePanel.this.panelSize.getHeight() * Math.random())));
            } else {
                this.coOrdX = ScenePanel.this.panelSize.getWidth();
                this.pointLight.setLocation(new Point((int)ScenePanel.this.panelSize.getWidth(), (int)(ScenePanel.this.panelSize.getHeight() * Math.random())));
            }
        }

        public void moveStar() {
            this.coOrdX += (double)(this.starSpeed * (float)STAR_SPEED);
            this.pointLight.setLocation(new Point((int)this.coOrdX, (int)this.pointLight.getLocation().getY()));
            if (this.pointLight.getLocation().getX() > ScenePanel.this.panelSize.getWidth() || this.pointLight.getLocation().getX() < 0.0) {
                this.resetStar();
            }
        }
    }
}

