/*
 * Decompiled with CFR 0.152.
 */
package ms1167;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import ms1167.Scene;
import ms1167.ScenePanel;

class Splash
extends ScenePanel
implements ActionListener,
ChangeListener {
    private JButton playButton;
    private JButton exitButton;
    private JButton helpButton;
    private JPanel titlePanel;
    private JSlider asteriodDensity;
    private JCheckBox damping;
    private JTextField densityDisplay;
    private Polygon rocket;
    private Polygon innerRocket;
    private Polygon flame;
    private Polygon innerFlame;
    private Line2D.Double laserBeam;
    private static final int ROCKET_SIZE = 12;
    private static final int INNER_SIZE = 8;
    private static final int TITLE_DEPTH = 25;
    private static final int TITLE_INDENT = 25;
    private static final int MIN_ASTERIODS = 50;
    private static final int MAX_ASTERIODS = 150;
    private static final double ROCKET_ANGLE = 0.325;
    private Font titleFont = new Font("SansSerif", 3, 85);
    private TextLayout title = new TextLayout("Asteroid Rocket", this.titleFont, new FontRenderContext(null, false, false));
    private AffineTransform titleAt = new AffineTransform();
    private FontMetrics titleMetrics = ((Component)this).getFontMetrics(this.titleFont);
    private Font creditFont = new Font("SansSerif", 2, 36);
    private TextLayout credit = new TextLayout("by Mark Shinn", this.creditFont, new FontRenderContext(null, false, false));
    private AffineTransform creditAt = new AffineTransform();
    private FontMetrics creditMetrics = ((Component)this).getFontMetrics(this.creditFont);

    Splash(Scene scene) {
        super(scene);
        this.playButton = new JButton("Play");
        this.playButton.addActionListener(this);
        this.exitButton = new JButton("Exit");
        this.exitButton.addActionListener(this);
        this.aboutButton = new JButton("About");
        this.aboutButton.addActionListener(this);
        this.helpButton = new JButton("Help");
        this.helpButton.addActionListener(this);
        this.asteriodDensity = new JSlider(50, 150, 50);
        this.asteriodDensity.setMajorTickSpacing(50);
        this.asteriodDensity.setMinorTickSpacing(10);
        this.asteriodDensity.setPaintTicks(true);
        this.asteriodDensity.setPaintTrack(true);
        this.asteriodDensity.addChangeListener(this);
        this.densityDisplay = this.makeTextField(5);
        this.upDateDisplay(this.densityDisplay);
        this.damping = new JCheckBox("Damped Rocket Movement", true);
        Box box = Box.createHorizontalBox();
        box.add(this.exitButton);
        box.add(Box.createHorizontalGlue());
        box.add(new JLabel(" Asteriod Density: "));
        box.add(this.asteriodDensity);
        box.add(this.densityDisplay);
        box.add(Box.createHorizontalGlue());
        box.add(this.damping);
        box.add(Box.createHorizontalGlue());
        box.add(this.aboutButton);
        box.add(this.helpButton);
        box.add(this.playButton);
        this.buttonPanel.add(box);
        this.constructRocket(500, 300);
        this.setFonts();
        this.playButton.grabFocus();
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        Stroke stroke = graphics2D.getStroke();
        graphics2D.setColor(Color.red);
        graphics2D.setStroke(new BasicStroke(6.0f));
        graphics2D.draw(this.laserBeam);
        graphics2D.setStroke(stroke);
        graphics2D.fill(this.flame);
        graphics2D.setColor(Color.yellow);
        graphics2D.fill(this.innerFlame);
        graphics2D.setColor(Color.black);
        graphics2D.draw(this.flame);
        graphics2D.draw(this.innerFlame);
        graphics2D.setColor(Color.gray);
        graphics2D.fill(this.rocket);
        graphics2D.setColor(Color.lightGray);
        graphics2D.fill(this.innerRocket);
        graphics2D.setColor(Color.black);
        graphics2D.draw(this.rocket);
        graphics2D.draw(this.innerRocket);
        graphics2D.setStroke(new BasicStroke(4.0f));
        graphics2D.setColor(Color.black);
        graphics2D.fill(this.title.getOutline(this.titleAt));
        graphics2D.setColor(Color.blue);
        graphics2D.draw(this.title.getOutline(this.titleAt));
        graphics2D.setStroke(new BasicStroke(1.0f));
        graphics2D.setColor(Color.black);
        graphics2D.fill(this.credit.getOutline(this.creditAt));
        graphics2D.setColor(Color.blue);
        graphics2D.draw(this.credit.getOutline(this.creditAt));
    }

    public void setFonts() {
        this.titleAt.translate(25.0, 25 + this.titleMetrics.getAscent());
        this.creditAt.translate(25 + this.titleMetrics.stringWidth("Asteroid Rocket") - this.creditMetrics.stringWidth("by Mark Shinn"), 25 + this.creditMetrics.getHeight() + this.titleMetrics.getHeight());
    }

    private void upDateDisplay(Object object) {
        this.densityDisplay.setText(new Integer(this.asteriodDensity.getValue()).toString() + "%");
    }

    private void constructRocket(int n, int n2) {
        this.rocket = new Polygon();
        this.rocket.addPoint(0, -9);
        this.rocket.addPoint(6, 6);
        this.rocket.addPoint(0, 3);
        this.rocket.addPoint(-6, 6);
        ScenePanel.expand(this.rocket, 12);
        ScenePanel.rotate(this.rocket, 0.325);
        this.rocket.translate(n, n2);
        this.innerRocket = new Polygon();
        this.innerRocket.addPoint(0, -9);
        this.innerRocket.addPoint(6, 6);
        this.innerRocket.addPoint(0, 3);
        this.innerRocket.addPoint(-6, 6);
        ScenePanel.expand(this.innerRocket, 8);
        ScenePanel.rotate(this.innerRocket, 0.325);
        this.innerRocket.translate(n, n2);
        this.flame = new Polygon();
        this.flame.addPoint(-3, 3);
        this.flame.addPoint(3, 3);
        this.flame.addPoint(0, 9);
        ScenePanel.expand(this.flame, 12);
        ScenePanel.rotate(this.flame, 0.325);
        this.flame.translate(n, n2);
        this.innerFlame = new Polygon();
        this.innerFlame.addPoint(-3, 3);
        this.innerFlame.addPoint(3, 3);
        this.innerFlame.addPoint(0, 9);
        ScenePanel.expand(this.innerFlame, 8);
        ScenePanel.rotate(this.innerFlame, 0.325);
        this.innerFlame.translate(n, n2);
        this.laserBeam = new Line2D.Double();
        this.laserBeam.setLine((double)this.rocket.xpoints[0] + 20.0 * Math.sin(2.0420352248333655), (double)this.rocket.ypoints[0] - 20.0 * Math.cos(2.0420352248333655), (double)this.rocket.xpoints[0] - 1000.0 * Math.sin(2.0420352248333655), (double)this.rocket.ypoints[0] + 1000.0 * Math.cos(2.0420352248333655));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        Object object = actionEvent.getSource();
        if (object == this.playButton) {
            this.calledFrom.showGame(this.asteriodDensity.getValue(), this.damping.isSelected());
        }
        if (object == this.helpButton) {
            this.calledFrom.showHelp();
        } else if (object == this.exitButton && JOptionPane.showConfirmDialog(this, "Are you sure you want to exit the game?", "Confirmation", 0, 2) == 0) {
            System.exit(0);
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (changeEvent.getSource() == this.asteriodDensity) {
            this.upDateDisplay(this.densityDisplay);
        }
    }
}

